DROP PROCEDURE [hips].[PatientMasterContactGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon
-- Create date: 15 Oct 2012
-- Description:   Gets a specific record from the Country Table
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterContactGet] 
(
	@PatientMasterId INT = null
)
AS
BEGIN
	SELECT  c.ContactId,
			c.Detail,
			c.ContactMethodId,
			cm.TelecommunicationType,
			cm.Description,
			cm.CdaType,
			c.DateCreated,
			c.UserCreated,
			c.DateModified,
			c.UserModified
			
	FROM  hips.PatientMasterContact AS pmc
	INNER JOIN hips.Contact AS c ON c.ContactId = pmc.ContactId
	INNER JOIN hips.ContactMethod AS cm ON cm.ContactMethodId = c.ContactMethodId
	WHERE pmc.PatientMasterId = @PatientMasterId OR @PatientMasterId IS NULL
END
GO

